/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: DevNetAp_error.h 48469 2014-10-09 08:32:07Z trieu                     $

   Description:
    ............................................................................

    Includes following functions:

   Changes:

     Version     Date        Author
     X.X.X.X   DD.MM.JJJJ  Mustermann
     Description................................................................
     ---------------------------------------------------------------------------

*******************************************************************************/

#ifndef __DEVNET_AP_ERROR_H
#define __DEVNET_AP_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// DeviceNet AP Task (Standard Dualport Application Task).
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
// Error General: Codes 0x01 - 0xFF.
//
// MessageId: TLR_E_DEVNET_AP_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_DEVNET_AP_COMMAND_INVALID  ((TLR_RESULT)0xC05B0001L)

//
// MessageId: TLR_E_DEVNET_AP_SERVICE_NOT_SUPPORTED
//
// MessageText:
//
//  Service not supported.
//
#define TLR_E_DEVNET_AP_SERVICE_NOT_SUPPORTED ((TLR_RESULT)0xC05B0002L)

//
// MessageId: TLR_E_DEVNET_AP_NO_DATA_BASE
//
// MessageText:
//
//  No data base found.
//
#define TLR_E_DEVNET_AP_NO_DATA_BASE     ((TLR_RESULT)0xC05B0010L)

//
// MessageId: TLR_E_DEVNET_AP_ERR_OPEN_DATA_BASE
//
// MessageText:
//
//  Error while opening data base.
//
#define TLR_E_DEVNET_AP_ERR_OPEN_DATA_BASE ((TLR_RESULT)0xC05B0011L)

//
// MessageId: TLR_E_DEVNET_AP_ERR_READ_DATA_BASE
//
// MessageText:
//
//  Error while reading data base.
//
#define TLR_E_DEVNET_AP_ERR_READ_DATA_BASE ((TLR_RESULT)0xC05B0012L)

//
// MessageId: TLR_E_DEVNET_AP_TABLE_NOT_FOUND
//
// MessageText:
//
//  Table not fond in data base.
//
#define TLR_E_DEVNET_AP_TABLE_NOT_FOUND  ((TLR_RESULT)0xC05B0013L)

//
// MessageId: TLR_E_DEVNET_AP_INVALID_DNM_DATA_BASE
//
// MessageText:
//
//  No valid DeviceNet data base.
//
#define TLR_E_DEVNET_AP_INVALID_DNM_DATA_BASE ((TLR_RESULT)0xC05B0014L)

//
// MessageId: TLR_E_DEVNET_AP_NON_EXCHANGE_SLAVE
//
// MessageText:
//
//  No data exchange with at least one slave.
//
#define TLR_E_DEVNET_AP_NON_EXCHANGE_SLAVE ((TLR_RESULT)0xC05B0100L)

//
// MessageId: TLR_E_DEVNET_AP_NON_EXCHANGE_ALL
//
// MessageText:
//
//  No slave in data exchange.
//
#define TLR_E_DEVNET_AP_NON_EXCHANGE_ALL ((TLR_RESULT)0xC05B0101L)

//
// MessageId: TLR_E_DEVNET_AP_ILLEGAL_PACKET_LENGTH
//
// MessageText:
//
//  Illegal packete length.
//
#define TLR_E_DEVNET_AP_ILLEGAL_PACKET_LENGTH ((TLR_RESULT)0xC05B0110L)

//
// MessageId: TLR_E_DEVNET_AP_WRONG_WD_VALUE
//
// MessageText:
//
//  Wrong watchdog.
//
#define TLR_E_DEVNET_AP_WRONG_WD_VALUE   ((TLR_RESULT)0xC05B0111L)




#endif  //__DEVNET_AP_ERROR_H

